//////////////////////////////////////////////////////////////////////////////////
//                                           Pleione : Engine for Mabinogi Project
//                                                                 plr::CASEImport
//                                                      : ase file importing class
//
//                                     eias erinys fecit, last update 2001. 04. 16
//                                          eias@nexon.co.kr, sheplany@nownuri.net
///////////////////////////////////////////////////////////// component of Pleione

elexname		= CASEImportElex;
elexfilename	= "PLR_ASEImportElex";

include = {*
//////////////////////////////////////////////////////////////////////////////////
//                                           Pleione : Engine for Mabinogi Project
//                                                             plr::CASEImportElex
//                                                                       : ase lex
//
//                                     eias erinys fecit, last update 2001. 04. 16
//                                          eias@nexon.co.kr, sheplany@nownuri.net
///////////////////////////////////////////////////////////// component of Pleione

*};

//////////////////////////////////////////////////////////////////////////////////
// regular
//////////////////////////////////////////////////////////////////////////////////
PLR_ASE_LBRACE								{:#{:};
PLR_ASE_RBRACE								{:#}:};
PLR_ASE_COLON								{:#::};
PLR_ASE_STRING								{:#"#"~*#":}
{*
	int len = strlen(TEXT);
	char* pTemp = new char[len - 1];
	strncpy(pTemp, TEXT + 1, len - 2);
	pTemp[len - 2] = 0;
	SetText(pTemp);
	delete[] pTemp;
*};
PLR_ASE_FLOAT								{:[#+#-]?0-9+.0-9+:}
(value)
{*
	RETURN new double(atof(TEXT));
*};
PLR_ASE_INTEGER								{:[#+#-]?0-9+:}
(value)
{*
	// just test
	RETURN new int(atoi(TEXT));
*};
PLR_ASE_A									{:A:};
PLR_ASE_B									{:B:};
PLR_ASE_C									{:C:};
PLR_ASE_AB									{:AB:};
PLR_ASE_BC									{:BC:};
PLR_ASE_CA									{:CA:};

//////////////////////////////////////////////////////////////////////////////////
PLR_ASE_HEADER_ID							{:#*3DSMAX_ASCIIEXPORT:};
PLR_ASE_COMMENT_ID							{:#*COMMENT:};

//////////////////////////////////////////////////////////////////////////////////
PLR_ASE_SCENE_ID							{:#*SCENE:};
	PLR_ASE_SCENE_FILENAME					{:#*SCENE_FILENAME:};
	PLR_ASE_SCENE_FIRSTFRAME				{:#*SCENE_FIRSTFRAME:};
	PLR_ASE_SCENE_LASTFRAME					{:#*SCENE_LASTFRAME:};
	PLR_ASE_SCENE_FRAMESPEED				{:#*SCENE_FRAMESPEED:};
	PLR_ASE_SCENE_TICKSPERFRAME				{:#*SCENE_TICKSPERFRAME:};
	PLR_ASE_SCENE_BACKGROUND_STATIC			{:#*SCENE_BACKGROUND_STATIC:};
	PLR_ASE_SCENE_AMBIENT_STATIC			{:#*SCENE_AMBIENT_STATIC:};

//////////////////////////////////////////////////////////////////////////////////
PLR_ASE_MATERIAL_LIST_ID					{:#*MATERIAL_LIST:};
	PLR_ASE_MATERIAL_COUNT					{:#*MATERIAL_COUNT:};
	PLR_ASE_MATERIAL						{:#*MATERIAL:};
	PLR_ASE_SUBMATERIAL						{:#*SUBMATERIAL:};
		PLR_ASE_MATERIAL_NAME				{:#*MATERIAL_NAME:};
		PLR_ASE_MATERIAL_CLASS				{:#*MATERIAL_CLASS:};
		PLR_ASE_MATERIAL_AMBIENT			{:#*MATERIAL_AMBIENT:};
		PLR_ASE_MATERIAL_DIFFUSE			{:#*MATERIAL_DIFFUSE:};
		PLR_ASE_MATERIAL_SPECULAR			{:#*MATERIAL_SPECULAR:};
		PLR_ASE_MATERIAL_SHINE				{:#*MATERIAL_SHINE:};
		PLR_ASE_MATERIAL_SHINESTRENGTH		{:#*MATERIAL_SHINESTRENGTH:};
		PLR_ASE_MATERIAL_TRANSPARENCY		{:#*MATERIAL_TRANSPARENCY:};
		PLR_ASE_MATERIAL_WIRESIZE			{:#*MATERIAL_WIRESIZE:};
		PLR_ASE_MATERIAL_SHADING			{:#*MATERIAL_SHADING:};
		PLR_ASE_MATERIAL_XP_FALLOFF			{:#*MATERIAL_XP_FALLOFF:};
		PLR_ASE_MATERIAL_SELFILLUM			{:#*MATERIAL_SELFILLUM:};
		PLR_ASE_MATERIAL_FALLOFF			{:#*MATERIAL_FALLOFF:};
		PLR_ASE_MATERIAL_SOFTEN				{:#*MATERIAL_SOFTEN:};
		PLR_ASE_MATERIAL_XP_TYPE			{:#*MATERIAL_XP_TYPE:};
		PLR_ASE_MAP_DIFFUSE					{:#*MAP_DIFFUSE:};
		PLR_ASE_MAP_BUMP					{:#*MAP_BUMP:};
			PLR_ASE_MAP_NAME				{:#*MAP_NAME:};
			PLR_ASE_MAP_CLASS				{:#*MAP_CLASS:};
			PLR_ASE_MAP_SUBNO				{:#*MAP_SUBNO:};
			PLR_ASE_MAP_AMOUNT				{:#*MAP_AMOUNT:};
			PLR_ASE_BITMAP					{:#*BITMAP:};
			PLR_ASE_MAP_TYPE				{:#*MAP_TYPE:};
		PLR_ASE_UVW_CROPPING				{:#*UVW_CROPPING:};
			PLR_ASE_UVW_U_OFFSET			{:#*UVW_U_OFFSET:};
			PLR_ASE_UVW_V_OFFSET			{:#*UVW_V_OFFSET:};
			PLR_ASE_UVW_U_TILING			{:#*UVW_U_TILING:};
			PLR_ASE_UVW_V_TILING			{:#*UVW_V_TILING:};
			PLR_ASE_UVW_ANGLE				{:#*UVW_ANGLE:};
			PLR_ASE_UVW_BLUR				{:#*UVW_BLUR:};
			PLR_ASE_UVW_BLUR_OFFSET			{:#*UVW_BLUR_OFFSET:};
			PLR_ASE_UVW_NOUSE_AMT			{:#*UVW_NOUSE_AMT:};
			PLR_ASE_UVW_NOISE_SIZE			{:#*UVW_NOISE_SIZE:};
			PLR_ASE_UVW_NOISE_LEVEL			{:#*UVW_NOISE_LEVEL:};
			PLR_ASE_UVW_NOISE_PHASE			{:#*UVW_NOISE_PHASE:};
			PLR_ASE_BITMAP_FILTER			{:#*BITMAP_FILTER:};

//////////////////////////////////////////////////////////////////////////////////
PLR_ASE_GEOMOBJECT_ID						{:#*GEOMOBJECT:};
PLR_ASE_HELPEROBJECT_ID						{:#*HELPEROBJECT:};
	PLR_ASE_NODE_NAME						{:#*NODE_NAME:};
	PLR_ASE_NODE_PARENT						{:#*NODE_PARENT:};
	PLR_ASE_NODE_TM							{:#*NODE_TM:};
		PLR_ASE_INHERIT_POS					{:#*INHERIT_POS:};
		PLR_ASE_INHERIT_ROT					{:#*INHERIT_ROT:};
		PLR_ASE_INHERIT_SCL					{:#*INHERIT_SCL:};
		PLR_ASE_TM_ROW0						{:#*TM_ROW0:};
		PLR_ASE_TM_ROW1						{:#*TM_ROW1:};
		PLR_ASE_TM_ROW2						{:#*TM_ROW2:};
		PLR_ASE_TM_ROW3						{:#*TM_ROW3:};
		PLR_ASE_TM_POS						{:#*TM_POS:};
		PLR_ASE_TM_ROTAXIS					{:#*TM_ROTAXIS:};
		PLR_ASE_TM_ROTANGLE					{:#*TM_ROTANGLE:};
		PLR_ASE_TM_SCALE					{:#*TM_SCALE:};
		PLR_ASE_TM_SCALEAXIS				{:#*TM_SCALEAXIS:};
		PLR_ASE_TM_SCALEAXISANG				{:#*TM_SCALEAXISANG:};
	PLR_ASE_BOUNDINGBOX_MIN					{:#*BOUNDINGBOX_MIN:};
	PLR_ASE_BOUNDINGBOX_MAX					{:#*BOUNDINGBOX_MAX:};
	PLR_ASE_MESH							{:#*MESH:};
		PLR_ASE_TIMEVALUE					{:#*TIMEVALUE:};
		PLR_ASE_MESH_NUMVERTEX				{:#*MESH_NUMVERTEX:};
		PLR_ASE_MESH_NUMFACES				{:#*MESH_NUMFACES:};
		//////////////////////////////////////////////////////////////////////////
		//	related	with vertex
		//////////////////////////////////////////////////////////////////////////
		PLR_ASE_MESH_VERTEX_LIST			{:#*MESH_VERTEX_LIST:};
			PLR_ASE_MESH_VERTEX				{:#*MESH_VERTEX:};
		//////////////////////////////////////////////////////////////////////////
		//	related with face
		//////////////////////////////////////////////////////////////////////////
		PLR_ASE_MESH_FACE_LIST				{:#*MESH_FACE_LIST:};
			PLR_ASE_MESH_FACE				{:#*MESH_FACE:};
		//////////////////////////////////////////////////////////////////////////
		//	related	with texture uv		
		//////////////////////////////////////////////////////////////////////////
		PLR_ASE_MESH_NUMTVERTEX				{:#*MESH_NUMTVERTEX:};
		PLR_ASE_MESH_TVERTLIST				{:#*MESH_TVERTLIST:};
			PLR_ASE_MESH_TVERT				{:#*MESH_TVERT:};
		//////////////////////////////////////////////////////////////////////////
		//	related	with texture face		
		//////////////////////////////////////////////////////////////////////////
		PLR_ASE_MESH_NUMTVFACES				{:#*MESH_NUMTVFACES:};
		PLR_ASE_MESH_TFACELIST				{:#*MESH_TFACELIST:};
			PLR_ASE_MESH_TFACE				{:#*MESH_TFACE:};
		//////////////////////////////////////////////////////////////////////////
		//	related	with vertex and face color	
		//////////////////////////////////////////////////////////////////////////
		PLR_ASE_MESH_NUMCVERTEX				{:#*MESH_NUMCVERTEX:};
		PLR_ASE_MESH_CVERTLIST				{:#*MESH_CVERTLIST:};
			PLR_ASE_MESH_VERTCOL			{:#*MESH_VERTCOL:};
		PLR_ASE_MESH_NUMCVFACES				{:#*MESH_NUMCVFACES:};
			PLR_ASE_MESH_CFACELIST			{:#*MESH_CFACELIST:};
			PLR_ASE_MESH_CFACE				{:#*MESH_CFACE:};
		//////////////////////////////////////////////////////////////////////////
		//	related	with vertex and face color
		//////////////////////////////////////////////////////////////////////////
		PLR_ASE_MESH_NORMALS				{:#*MESH_NORMALS:};
			PLR_ASE_MESH_FACENORMAL			{:#*MESH_FACENORMAL:};
			PLR_ASE_MESH_VERTEXNORMAL		{:#*MESH_VERTEXNORMAL:};

		//////////////////////////////////////////////////////////////////////////
		// extension
		//////////////////////////////////////////////////////////////////////////
		PLR_ASE_MESH_NUMCVERTEXEX			{:#*MESH_NUMCVERTEXEX:};
			PLR_ASE_MESH_CVERTLISTEX		{:#*MESH_CVERTLISTEX:};
			PLR_ASE_MESH_VERTCOLEX			{:#*MESH_VERTCOLEX:};		

		PLR_ASE_MESH_NUMCVERTEXALPHA		{:#*MESH_NUMCVERTEXALPHA:};
			PLR_ASE_MESH_CVERTLISTALPHA		{:#*MESH_CVERTLISTALPHA:};
			PLR_ASE_MESH_VERTCOLALPHA		{:#*MESH_VERTCOLALPHA:};		

		PLR_ASE_MESH_NUMCVFACESEX			{:#*MESH_NUMCVFACESEX:};
			PLR_ASE_MESH_CFACELISTEX		{:#*MESH_CFACELISTEX:};
	//////////////////////////////////////////////////////////////////////////////

	PLR_ASE_PROP_MOTIONBLUR					{:#*PROP_MOTIONBLUR:};
	PLR_ASE_PROP_CASTSHADOW					{:#*PROP_CASTSHADOW:};
	PLR_ASE_PROP_RECVSHADOW					{:#*PROP_RECVSHADOW:};

	//////////////////////////////////////////////////////////////////////////////
	//	related with animation
	//////////////////////////////////////////////////////////////////////////////
	PLR_ASE_TM_ANIMATION					{:#*TM_ANIMATION:};
		PLR_ASE_CONTROL_POS_BEZIER			{:#*CONTROL_POS_BEZIER:};
	PLR_ASE_CONTROL_POS_TRACK				{:#*CONTROL_POS_TRACK:};
			PLR_ASE_CONTROL_BEZIER_POS_KEY	{:#*CONTROL_BEZIER_POS_KEY:};
		PLR_ASE_CONTROL_POS_SAMPLE			{:#*CONTROL_POS_SAMPLE:};
		PLR_ASE_CONTROL_ROT_TCB				{:#*CONTROL_ROT_TCB:};
	PLR_ASE_CONTROL_ROT_LINEAR				{:#*CONTROL_ROT_LINEAR:};
	PLR_ASE_CONTROL_ROT_TRACK				{:#*CONTROL_ROT_TRACK:};
			PLR_ASE_CONTROL_ROT_KEY			{:#*CONTROL_ROT_KEY:};
			PLR_ASE_CONTROL_TCB_ROT_KEY		{:#*CONTROL_TCB_ROT_KEY:};
			PLR_ASE_CONTROL_ROT_SAMPLE		{:#*CONTROL_ROT_SAMPLE:};

	//////////////////////////////////////////////////////////////////////////////
	//	related with texture and material
	//////////////////////////////////////////////////////////////////////////////
	PLR_ASE_MATERIAL_REF					{:#*MATERIAL_REF:};

//////////////////////////////////////////////////////////////////////////////////
//  related with light
//////////////////////////////////////////////////////////////////////////////////
	PLR_ASE_LIGHTOBJECT						{:#*LIGHTOBJECT:};
		PLR_ASE_LIGHT_TYPE					{:#*LIGHT_TYPE:};
		PLR_ASE_LIGHT_SHADOWS				{:#*LIGHT_SHADOWS:};
		PLR_ASE_LIGHT_USE_LIGHT				{:#*LIGHT_USELIGHT:};
		PLR_ASE_LIGHT_SPOT_SHAPE			{:#*LIGHT_SPOTSHAPE:};
		PLR_ASE_LIGHT_USEGLOBAL				{:#*LIGHT_USEGLOBAL:};
		PLR_ASE_LIGHT_ABSMAPBIAS			{:#*LIGHT_ABSMAPBIAS:};
		PLR_ASE_LIGHT_OVERSHOOT				{:#*LIGHT_OVERSHOOT:};
		PLR_ASE_LIGHT_SETTINGS				{:#*LIGHT_SETTINGS:};
			PLR_ASE_LIGHT_COLOR				{:#*LIGHT_COLOR:};
			PLR_ASE_LIGHT_INTENS			{:#*LIGHT_INTENS:};
			PLR_ASE_LIGHT_ASPECT			{:#*LIGHT_ASPECT:};
			PLR_ASE_LIGHT_TDIST				{:#*LIGHT_TDIST:};
			PLR_ASE_LIGHT_MAPBIAS			{:#*LIGHT_MAPBIAS:};
			PLR_ASE_LIGHT_MAPRANGE			{:#*LIGHT_MAPRANGE:};
			PLR_ASE_LIGHT_MAPSIZE			{:#*LIGHT_MAPSIZE:};
			PLR_ASE_LIGHT_RAYBIAS			{:#*LIGHT_RAYBIAS:};
